# -*- coding: utf-8 -*-

"""!
SUITE USERS NOTES Maya Tips & TimeEditor Seminar
For Maya2016 - Custom Outliner V4.0
               Set Color in Outliner With Select/Copy/Reset
               + Joint , set to IndexColor
               Add [Up] [Down] Move's selected node in Outliner
               Add try:'No Reorder'
               Update to Unexpected Error "None" in list
               Add Display Mode to Flat
@file
@author Ritaro

"""
import maya.cmds as cmds
import maya.mel as mel
import os
import imp, os.path, sys

def color_index(value,outliner_panel_name):
    set_color_index = value + 1
    cmds.colorIndexSliderGrp(outliner_panel_name + 'oliner_color', edit=True,value=set_color_index)

def apply_color(outliner_panel_name):
    if not cmds.ls( sl=True ):
        cmds.confirmDialog( title='WARNIG',message='Noting is Selected !!')
        sys.exit()
    else:
        selected_object = cmds.ls(sl=True)
        for s_o in selected_object:
            if cmds.objectType(s_o, isType='transform' ) or cmds.objectType(s_o, isType='joint' ) == True:
                pass
            else:
                cmds.confirmDialog(title='WARNING',message='No Color in Selected Object !!')
                sys.exit()
        cmds.select(clear=True)

        set_h_color_index = cmds.colorIndexSliderGrp(outliner_panel_name + 'oliner_color', q=True,value=True) - 1

        if set_h_color_index < 1 or 31 < set_h_color_index :
            cmds.select(selected_object[0],r=True)
            sys.exit()
        else:
            set_h_color_rbg = cmds.colorIndex(set_h_color_index, q=True )

            for node in selected_object:
                cmds.setAttr(node + ".useOutlinerColor", 1)
                cmds.setAttr(node + ".outlinerColor",set_h_color_rbg[0],set_h_color_rbg[1],set_h_color_rbg[2])

            if cmds.checkBoxGrp(outliner_panel_name + 'viewport_check',q=True,value1=True) == True:
                cmds.setAttr(node + ".overrideEnabled", 1)
                cmds.setAttr(node + ".overrideRGBColors", 0)
                cmds.setAttr(node + ".overrideColor", set_h_color_index) 

            cmds.select(selected_object[0],r=True)

def select_same_color(outliner_panel_name):
    if not cmds.ls( sl=True ):
        cmds.confirmDialog( title='WARNING',message='Noting is Selected !!')
        sys.exit()
    else:
        selected_object = cmds.ls(sl=True)
        for c_o in selected_object:
            if cmds.objectType(c_o, isType='transform' ) or cmds.objectType(c_o, isType='joint' ) == True:
                pass
            else:
                cmds.confirmDialog(title='WARNING',message='No Color in Selected Object !!')
                sys.exit()
        if cmds.getAttr(selected_object[0] + ".useOutlinerColor") != True:
            sys.exit()
        else:
            selected_o_color = cmds.getAttr(selected_object[0] +".outlinerColor")
            cmds.select(clear=True)

            select_o_list = []

            mel.eval('SelectAllTransforms;')
            all_tr_obj = cmds.ls(sl=True)
            for a_t_o in all_tr_obj:
                if cmds.getAttr(a_t_o + ".useOutlinerColor") != True:
                    all_tr_obj.remove(a_t_o)

            cmds.select(clear=True)

            for o_obj in all_tr_obj:
                o_obj_color = cmds.getAttr(o_obj +".outlinerColor")
                if o_obj_color[0] == selected_o_color[0]:
                    select_o_list.append(o_obj)

            if select_o_list != []:
                for c_o_obj in select_o_list: 
                    cmds.select(c_o_obj,add=True)

            new_color_index = 0

            for i_col in range(30):
                i_col = i_col + 1
                if [selected_o_color[0][0],selected_o_color[0][1],selected_o_color[0][2]] == cmds.colorIndex(i_col, q=True ):
                    new_color_index = i_col + 1

            cmds.colorIndexSliderGrp(outliner_panel_name + 'oliner_color',edit=True,value=new_color_index)
            cmds.intSlider(outliner_panel_name + 'oliner_color_index',edit=True,value=new_color_index - 1)


def copy_color(outliner_panel_name):
    if not cmds.ls( sl=True ):
        cmds.confirmDialog( title='WARNIG',message='Noting is Selected !!')
    else:
        selected_p_object = cmds.ls(sl=True)[0]
        if cmds.objectType(selected_p_object, isType='transform' ) or cmds.objectType(selected_p_object, isType='joint' ) == True:
            pass
        else:
            cmds.confirmDialog(title='WARNING',message='No Color in Selected Object !!')
            sys.exit()
            
        if cmds.getAttr(selected_p_object + ".useOutlinerColor") != True:
            cmds.select(selected_p_object,r=True)
            sys.exit()

        selected_p_color = cmds.getAttr(selected_p_object +".outlinerColor")
        selected_objects = cmds.ls(sl=True)
        for p_o in selected_objects:
            if cmds.objectType(p_o, isType='transform' ) or cmds.objectType(p_o, isType='joint' ) == True:
                pass
            else:
                cmds.confirmDialog(title='WARNING',message='No Color in Selected Object !!')
                sys.exit()
                
        selected_objects.remove(selected_p_object)
        cmds.select(clear=True)

        for p_col in range(30):
            p_col = p_col + 1
            if [selected_p_color[0][0], selected_p_color[0][1],selected_p_color[0][2]] == cmds.colorIndex(p_col, q=True ):
                new_p_color_index = p_col + 1

        cmds.colorIndexSliderGrp(outliner_panel_name + 'oliner_color',edit=True,value=new_p_color_index)
        cmds.intSlider(outliner_panel_name + 'oliner_color_index',edit=True,value=new_p_color_index - 1)

        for s_p_o in selected_objects:
            cmds.setAttr(s_p_o + ".useOutlinerColor", 1)
            cmds.setAttr(s_p_o + ".outlinerColor",
                selected_p_color[0][0],selected_p_color[0][1],selected_p_color[0][2])

            if cmds.checkBoxGrp(outliner_panel_name + 'viewport_check',q=True,value1=True) == True:
                cmds.setAttr(s_p_o + ".overrideEnabled", 1)
                cmds.setAttr(s_p_o + ".overrideRGBColors", 0)
                cmds.setAttr(s_p_o + ".overrideColor", new_p_color_index - 1)
                
        cmds.select(selected_p_object,r=True)

def reset_color(outliner_panel_name):
    if not cmds.ls( sl=True ):
        cmds.confirmDialog( title='WARNIG',message='Noting is Selected !!')
        sys.exit()
    else:
        selected_r_objects = cmds.ls(sl=True)
        for r_o in selected_r_objects:
            if cmds.objectType(r_o, isType='transform' ) or cmds.objectType(r_o, isType='joint' ) == True:
                pass
            else:
                cmds.confirmDialog(title='WARNING',message='No Color in Selected Object !!')
                sys.exit()

        for s_r_o in selected_r_objects:
            cmds.setAttr(s_r_o + ".useOutlinerColor", 0)
            cmds.setAttr(s_r_o + ".outlinerColor", 0,0,0)

            if cmds.checkBoxGrp(outliner_panel_name + 'viewport_check',q=True,value1=True) == True:
                cmds.setAttr(s_r_o + ".overrideEnabled", 0)
                cmds.setAttr(s_r_o + ".overrideRGBColors", 0)
                cmds.setAttr(s_r_o + ".overrideColor", 0)

        cmds.colorIndexSliderGrp(outliner_panel_name + 'oliner_color',edit=True,value=0)
        cmds.intSlider(outliner_panel_name + 'oliner_color_index',edit=True,value=0)

        cmds.select(selected_r_objects[0],r=True)

def move_node_up(*args):
    if not cmds.ls( sl=True ):
        cmds.confirmDialog( title='WARNIG',message='Noting is Selected !!')
        sys.exit()
    else:
        try:
            selected_up_objects = cmds.ls(sl=True)
            cmds.reorder( selected_up_objects, relative= -1 )
        except:
            cmds.confirmDialog( title='WARNIG',message='No Reorder')
            sys.exit()

def move_node_down(*args):
    if not cmds.ls( sl=True ):
        cmds.confirmDialog( title='WARNIG',message='Noting is Selected !!')
        sys.exit()
    else:
        try:
            selected_down_objects = cmds.ls(sl=True)
            cmds.reorder( selected_down_objects, relative= 1 )
        except:
            cmds.confirmDialog( title='WARNIG',message='No Reorder')
            sys.exit()

def display_mode(outliner_panel_name):
    if cmds.outlinerEditor(outliner_panel_name, q=True, displayMode=True ) == "DAG":
        cmds.outlinerEditor(outliner_panel_name, edit=True, displayMode='List' )
        cmds.button(outliner_panel_name +"List",edit=True,bgc=[0.7,0.2,0.2])
    else:
        cmds.outlinerEditor(outliner_panel_name, edit=True, displayMode='DAG' )
        cmds.button(outliner_panel_name +"List",edit=True,bgc=[0.2,0.2,0.2])

def custom_outliner(*args):

    info = cmds.about(version=True)
    version = info.split(" ")[0]

    invis_panel = cmds.getPanel(invisiblePanels=True)

    custom_outlinerpanel = cmds.getPanel(type='outlinerPanel')
    try:
        if 'outlinerPanel1' in custom_outlinerpanel:
            custom_outlinerpanel.remove('outlinerPanel1')
    except:
        pass

    try:
        for c_outlinerp in custom_outlinerpanel:
            if c_outlinerp in invis_panel:
                cmds.deleteUI(c_outlinerp,panel=True)
    except:
        pass

    try:
        olp_panel_no_a = str(len(cmds.getPanel(type='outlinerPanel')) + 1)
    except:
        olp_panel_no_a = '1'

    if cmds.window('custom_outlinerpanel'+ olp_panel_no_a, exists=True):
        n_olpphpanels = cmds.getPanel(type='outlinerPanel')
        n_olpphpanels.remove('outlinerPanel1')
        biggest_p = 1
        for o_panel in n_olpphpanels:
            if int(o_panel[len('custom_outlinerpanel'):]) > biggest_p:
                biggest_p = int(o_panel[len('custom_outlinerpanel'):])

        olp_panel_no_a = str(biggest_p + 1)

    try:
        win1 = cmds.window('custom_outlinerpanel'+ olp_panel_no_a,
            title='CustomOutliner'+ olp_panel_no_a,resizeToFitChildren=True, widthHeight=(350, 600))
    except:
        olp_panel_no_a = str( int(olp_panel_no_a) + 1 )

        win1 = cmds.window('custom_outlinerpanel'+ olp_panel_no_a,
            title='CustomOutliner'+ olp_panel_no_a,resizeToFitChildren=True, widthHeight=(350, 600))

    outliner_panel_name = "custom_outlinerpanel" + olp_panel_no_a
    print(outliner_panel_name)

    pane1 = cmds.paneLayout(configuration='horizontal2', paneSize=[2,1,1], parent=win1)
    outlinergraphmenu = 'custom_outlinerpanel' + olp_panel_no_a
    custom_outliner = cmds.outlinerPanel(outlinergraphmenu, label=outlinergraphmenu, parent=pane1)

    if version <= '2015': 
        cmds.outlinerEditor(custom_outliner, edit=True, 
            mainListConnection='worldList',
            selectionConnection='modelList',
            showShapes=False, 
            showReferenceNodes=False,
            showReferenceMembers=False,
            showAttributes=False,
            showConnected=False,
            showAnimCurvesOnly=False,
            autoExpand=False, 
            showDagOnly=True, 
            ignoreDagHierarchy=False,
            expandConnections=False, 
            showNamespace=True,
            showCompounds=True,
            showNumericAttrsOnly=False,
            highlightActive=True, 
            autoSelectNewObjects=False, 
            doNotSelectNewObjects=False, 
            transmitFilters=False, 
            showSetMembers=True, 
            setFilter='defaultSetFilter', 
            ignoreHiddenAttribute=False )
    else:
        cmds.outlinerEditor(custom_outliner, edit=True, 
            mainListConnection='worldList',
            selectionConnection='modelList',
            showShapes=False, 
            showReferenceNodes=False,
            showReferenceMembers=False,
            showAttributes=False,
            showConnected=False,
            showAnimCurvesOnly=False,
            autoExpand=False, 
            showDagOnly=True, 
            ignoreDagHierarchy=False,
            expandConnections=False, 
            showNamespace=True,
            showCompounds=True,
            showNumericAttrsOnly=False,
            highlightActive=True, 
            autoSelectNewObjects=False, 
            doNotSelectNewObjects=False, 
            transmitFilters=False, 
            showSetMembers=True, 
            setFilter='defaultSetFilter', 
            ignoreHiddenAttribute=False, 
            ignoreOutlinerColor=False )

    cmds.setParent('..')
    cmds.columnLayout( adjustableColumn=True )
    cmds.rowLayout(numberOfColumns=2,adjustableColumn=2)
    cmds.colorIndexSliderGrp(outliner_panel_name + 'oliner_color',
        label='Select Color ',min=0,max=32,value=0,columnWidth3=[80,70,0])
    cmds.intSlider(outliner_panel_name + 'oliner_color_index',
        min=0, max=31, value=0, step=1,dragCommand=lambda x:color_index(int(x),outliner_panel_name))

    cmds.setParent('..')
    cmds.columnLayout( adjustableColumn=True )
    cmds.rowLayout(numberOfColumns=6,adjustableColumn=4)

    cmds.button("Up",label='Up',bgc=[0.35,0.7,0.35],align='left',width=40,command=move_node_up)
    cmds.text(' ',align='left',width=10)
    cmds.button(outliner_panel_name +"List",label='FLAT',align='left',width=80,
        bgc=[0.2,0.2,0.2],command=lambda x:display_mode(outliner_panel_name))
    cmds.text('  ',align='left',width=10)
    cmds.checkBoxGrp(outliner_panel_name + 'viewport_check',label=' ',numberOfCheckBoxes=1,columnWidth2=[0,40])
    cmds.text('Channge Color in Viewport ',align='center')

    cmds.setParent('..')
    cmds.columnLayout( adjustableColumn=True )

    cmds.rowLayout(numberOfColumns=6,adjustableColumn=3)
    cmds.button("Down",label='Down',bgc=[0.35,0.7,0.35],align='left',width=40,command=move_node_down)
    cmds.text('  ',align='left',width=10)
    cmds.button(outliner_panel_name + 'Apply',label=' Apply ',
        bgc=[0.35,0.5,0.35],command=lambda x:apply_color(outliner_panel_name))

    cmds.button(outliner_panel_name + 'Select',label=' Select ',
        bgc=[0.3,0.4,0.3],command=lambda x:select_same_color(outliner_panel_name))

    cmds.button(outliner_panel_name + 'Copy',label=' Copy ',
        bgc=[0.25,0.3,0.25],command=lambda x:copy_color(outliner_panel_name))

    cmds.button(outliner_panel_name + 'Reset',label=' Reset ',
        bgc=[0.2,0.2,0.2],command=lambda x:reset_color(outliner_panel_name))

    cmds.showWindow()
    
    if version <= '2015':
        chk = cmds.confirmDialog( title='WARNING',
            message=' Over Maya2016 is Required !!',button=['Yes'],defaultButton='Yes')
        if chk == 'Yes':pass
