# -*- coding: utf-8 -*-

import maya.cmds as cmds
import maya.mel as mel

def step_backward(*args):
    grp_panel_no_b = str( cmds.getPanel( withFocus=True )[11:] )
    by = cmds.intField('nStep'+ grp_panel_no_b,query=True,value=True)
    curr = cmds.currentTime( query=True )
    min = cmds.playbackOptions(query=True,minTime=True)
    max = cmds.playbackOptions(query=True,maxTime=True)

    if curr != min and (curr - by ) >= min and (curr - by) < max:
        cmds.currentTime(curr - by,edit=True)
    else:
        cmds.currentTime(max,edit=True)

def play_forward(*args):
    grp_panel_no_b = str( cmds.getPanel( withFocus=True )[11:] )

    if cmds.symbolButton('play_forward'+ grp_panel_no_b,q=True,image=True) == 'timeplay.xpm':
        cmds.symbolButton('play_forward'+ grp_panel_no_b,edit=True,image='timestop.xpm')
    elif cmds.symbolButton('play_forward'+ grp_panel_no_b,q=True,image=True) == 'timestop.xpm':
        cmds.symbolButton('play_forward'+ grp_panel_no_b,edit=True,image='timeplay.xpm')
    mel.eval('playButtonForward;')

def step_forward(*args):
    grp_panel_no_b = str( cmds.getPanel( withFocus=True )[11:] )
    by = cmds.intField('nStep'+ grp_panel_no_b,query=True,value=True)
    curr = cmds.currentTime( query=True )
    min = cmds.playbackOptions(query=True,minTime=True)
    max = cmds.playbackOptions(query=True,maxTime=True)

    if curr != max and (curr + by ) <= max and (curr + by) > min:
        cmds.currentTime(curr + by,edit=True)
    else:
        cmds.currentTime(min,edit=True)

def radio_button_grp_key(radio_button_value):

    panel_button_no_var = cmds.getPanel( withFocus=True ) + "var"

    if 1 <= radio_button_value <= 3:
        panel_button_no = radio_button_value
        cmds.optionVar( intValue=(panel_button_no_var, panel_button_no ) )

def start_tan(tangent_value):

    try:
        cmds.keyframe( query=True, selected=True, name=True)[0]

        panel_button_no_var = cmds.getPanel( withFocus=True ) + "var"
        panel_button_no = cmds.optionVar( q=panel_button_no_var )
        if cmds.optionVar( exists=panel_button_no_var ) == False:
            panel_button_no = 1

        cmds.keyTangent( lock=False )
        if panel_button_no == 1:
            cmds.keyTangent(edit=True,absolute=True, inAngle=tangent_value, outAngle=tangent_value)
        elif panel_button_no == 2:
            cmds.keyTangent(edit=True,absolute=True, inAngle=tangent_value)
        elif panel_button_no == 3:
            cmds.keyTangent(edit=True,absolute=True, outAngle=tangent_value)
        cmds.keyTangent( lock=True )

    except:
        print 'Animation Key is Not Seleced'


def anim_save(*args):
    if not cmds.pluginInfo("animImportExport",q=True,loaded=True):
        cmds.loadPlugin( 'animImportExport' )
        cmds.pluginInfo( 'animImportExport', edit=True, autoload=True )

    if not cmds.ls( sl=True ):
        print 'Nothing is selected to Export'

    else:
        singleFilter = 'animExport(*.anim)'
        anim_filename = cmds.fileDialog2(
            fileMode=0, 
            fileFilter=singleFilter,
            dialogStyle=2,
            caption='Save Key Animaton'
            )
        if anim_filename:
            cmds.file(anim_filename[0],
                type='animExport',
                exportSelected=True,
                options='options=keys;hierarchy=below;controlPoints=0;shapes=1;copyKeyCmd=-animation objects -option keys -hierarchy below -controlPoints 0 -shape 1'
                )

def anim_load(*args):
    if not cmds.pluginInfo("animImportExport",q=True,loaded=True):
        cmds.loadPlugin( 'animImportExport' )
        cmds.pluginInfo( 'animImportExport', edit=True, autoload=True )

    if not cmds.ls( sl=True ):
        print 'Nothing is selected to Export'

    else:
        selected_obj = cmds.ls( sl=True )[0]

        singleFilter = 'animImport(*.anim)'
        anim_filename = cmds.fileDialog2(
            fileMode=1,
            fileFilter=singleFilter,
            dialogStyle=2,
            caption='Load Key Animaton'
            )
        if anim_filename:
            cmds.file(
                anim_filename[0],
                type='animImport',
                i=True,
                ignoreVersion=True,
                renameAll=True,
                options='targetTime=4;option=replace;connect=0'
                )

        cmds.select(selected_obj, r=True )


def fbx_save(*args):
    try:
        if not cmds.pluginInfo("fbxmaya",q=True,loaded=True):
            cmds.loadPlugin( 'fbxmaya' )
            cmds.pluginInfo( 'fbxmaya', edit=True, autoload=True )
    except:
        print 'FBX plugin is not installed'

    if not cmds.ls( sl=True ):
        print 'Nothing is selected to Export'

    else:
        singleFilter = 'FBX(*.fbx)'
        fbx_filename = cmds.fileDialog2(
            fileMode=0, 
            fileFilter=singleFilter,
            dialogStyle=2,
            caption='Save FBX Animaton'
            )
        if fbx_filename:
            mel.eval('FBXExportConvertUnitString "cm"')
            cmds.file(fbx_filename[0],
                force=True,
                type='FBX export',
                preserveReferences=True,
                exportSelected=True,
                options='verboseUnits=0;options=keys;hierarchy=none;controlPoints=0;shapes=1;useChannelBox=0;copyKeyCmd=-animation objects -option keys -hierarchy none -controlPoints 0 -shape 1'
                )

def fbx_load(*args):
    try:
        if not cmds.pluginInfo("fbxmaya",q=True,loaded=True):
            cmds.loadPlugin( 'fbxmaya' )
            cmds.pluginInfo( 'fbxmaya', edit=True, autoload=True )
    except:
        print 'FBX plugin is not installed'

    if not cmds.ls( sl=True ):
        print 'Nothing is selected to Export'

    else:
        selected_obj = cmds.ls( sl=True )[0]

        singleFilter = 'FBX(*.fbx)'
        fbx_filename = cmds.fileDialog2(
            fileMode=1,
            fileFilter=singleFilter,
            dialogStyle=2,
            caption='Load FBX Animaton'
            )
        if fbx_filename:
            mel.eval('FBXImportSetLockedAttribute -v true')
            mel.eval('FBXImportMode -v merge')
            mel.eval('FBXImportConvertUnitString "cm"')
            cmds.file(
                fbx_filename[0],
                type='FBX',
                i=True,
                ignoreVersion=True
                )

        cmds.select(selected_obj, r=True )

def select_objfrom_curve(*args):
    if not cmds.ls( sl=True ):
        print 'No@Curve is selected'
    else:
        selected_f_curve = cmds.keyframe( query=True, lastSelected=True, name=True)[0]
        cmds.select( (selected_f_curve[:selected_f_curve.index('_')]) , r=True)


def select_curve_tx(*args):
    if not cmds.ls( sl=True ):
        print 'Nothing is selected'
    else:
        first_selected = cmds.ls( sl=True )[0]
        cmds.selectKey(first_selected,replace=True,attribute='translateX')

def filter_tx( dragControl, x, y, modifiers ):
    if not cmds.ls( sl=True ):
        print 'Nothing is selected'
    else:
        if modifiers == 0:
            first_selected = cmds.ls( sl=True )[0]
            o_time = int(cmds.currentTime( query=True ))
            cmds.selectKey(first_selected,replace=True,time=(o_time,o_time),attribute='translateX')
        elif modifiers == 1:
            grp_panel_no_b = str( cmds.getPanel( withFocus=True )[11:] )
            outline_ed_name = "graphEditor" + grp_panel_no_b + 'OutlineEd'
            mel.eval('string $outlineed_name = "%s"' % outline_ed_name)
            c_tx = cmds.button('b_c_tx'+ grp_panel_no_b,q=1,bgc=True)
            if(c_tx==[0.30000762951094834, 0.0, 0.0]):
                cmds.button('b_c_tx'+ grp_panel_no_b,edit=1,bgc=[1.0,0.0,0.0])
                mel.eval('filterUISelectAttributesCheckbox translateX 1 $outlineed_name;')
            elif(c_tx==[1.0,0.0,0.0]):
                cmds.button('b_c_tx'+ grp_panel_no_b,edit=1,bgc=[0.3,0.0,0.0])
                mel.eval('filterUISelectAttributesCheckbox translateX 0 $outlineed_name;')

def filter_tx2(*args):
    pass

def select_curve_ty(*args):
    if not cmds.ls( sl=True ):
        print 'Nothing is selected'
    else:
        first_selected = cmds.ls( sl=True )[0]
        cmds.selectKey(first_selected,replace=True,attribute='translateY')

def filter_ty( dragControl, x, y, modifiers ):
    if not cmds.ls( sl=True ):
        print 'Nothing is selected'
    else:
        if modifiers == 0:
            first_selected = cmds.ls( sl=True )[0]
            o_time = int(cmds.currentTime( query=True ))
            cmds.selectKey(first_selected,replace=True,time=(o_time,o_time),attribute='translateY')
        elif modifiers == 1:
            grp_panel_no_b = str( cmds.getPanel( withFocus=True )[11:] )
            outline_ed_name = "graphEditor" + grp_panel_no_b + 'OutlineEd'
            mel.eval('string $outlineed_name = "%s"' % outline_ed_name)
            c_ty = cmds.button('b_c_ty'+ grp_panel_no_b,q=1,bgc=True)
            if(c_ty==[0.0,0.30000762951094834,0.0]):
                cmds.button('b_c_ty'+ grp_panel_no_b,edit=1,bgc=[0.0,1.0,0.0])
                mel.eval('filterUISelectAttributesCheckbox translateY 1 $outlineed_name;')
            elif(c_ty==[0.0,1.0,0.0]):
                cmds.button('b_c_ty'+ grp_panel_no_b,edit=1,bgc=[0.0,0.3,0.0])
                mel.eval('filterUISelectAttributesCheckbox translateY 0 $outlineed_name;')

def filter_ty2(*args):
    pass

def select_curve_tz(*args):
    if not cmds.ls( sl=True ):
        print 'Nothing is selected'
    else:
        first_selected = cmds.ls( sl=True )[0]
        cmds.selectKey(first_selected,replace=True,attribute='translateZ')

def filter_tz( dragControl, x, y, modifiers ):
    if not cmds.ls( sl=True ):
        print 'Nothing is selected'
    else:
        if modifiers == 0:
            first_selected = cmds.ls( sl=True )[0]
            o_time = int(cmds.currentTime( query=True ))
            cmds.selectKey(first_selected,replace=True,time=(o_time,o_time),attribute='translateZ')
        elif modifiers == 1:
            grp_panel_no_b = str( cmds.getPanel( withFocus=True )[11:] )
            outline_ed_name = "graphEditor" + grp_panel_no_b + 'OutlineEd'
            mel.eval('string $outlineed_name = "%s"' % outline_ed_name)
            c_tz = cmds.button('b_c_tz'+ grp_panel_no_b,q=1,bgc=True)
            if(c_tz==[0.0,0.0,0.30000762951094834]):
                cmds.button('b_c_tz'+ grp_panel_no_b,edit=1,bgc=[0.0,0.0,1.0])
                mel.eval('filterUISelectAttributesCheckbox translateZ 1 $outlineed_name;')
            elif(c_tz==[0.0,0.0,1.0]):
                cmds.button('b_c_tz'+ grp_panel_no_b,edit=1,bgc=[0.0,0.0,0.3])
                mel.eval('filterUISelectAttributesCheckbox translateZ 0 $outlineed_name;')

def filter_tz2(*args):
    pass

def select_curve_rx(*args):
    if not cmds.ls( sl=True ):
        print 'Nothing is selected'
    else:
        first_selected = cmds.ls( sl=True )[0]
        cmds.selectKey(first_selected,replace=True,attribute='rotateX')

def filter_rx( dragControl, x, y, modifiers ):
    if not cmds.ls( sl=True ):
        print 'Nothing is selected'
    else:
        if modifiers == 0:
            first_selected = cmds.ls( sl=True )[0]
            o_time = int(cmds.currentTime( query=True ))
            cmds.selectKey(first_selected,replace=True,time=(o_time,o_time),attribute='rotateX')
        elif modifiers == 1:
            grp_panel_no_b = str( cmds.getPanel( withFocus=True )[11:] )
            outline_ed_name = "graphEditor" + grp_panel_no_b + 'OutlineEd'
            mel.eval('string $outlineed_name = "%s"' % outline_ed_name)
            c_rx = cmds.button('b_c_rx'+ grp_panel_no_b,q=1,bgc=True)
            if(c_rx==[0.30000762951094834, 0.0, 0.0]):
                cmds.button('b_c_rx'+ grp_panel_no_b,edit=1,bgc=[1.0,0.0,0.0])
                mel.eval('filterUISelectAttributesCheckbox rotateX 1 $outlineed_name;')
            elif(c_rx==[1.0,0.0,0.0]):
                cmds.button('b_c_rx'+ grp_panel_no_b,edit=1,bgc=[0.3,0.0,0.0])
                mel.eval('filterUISelectAttributesCheckbox rotateX 0 $outlineed_name;')

def filter_rx2(*args):
    pass

def select_curve_ry(*args):
    if not cmds.ls( sl=True ):
        print 'Nothing is selected'
    else:
        first_selected = cmds.ls( sl=True )[0]
        cmds.selectKey(first_selected,replace=True,attribute='rotateY')

def filter_ry( dragControl, x, y, modifiers ):
    if not cmds.ls( sl=True ):
        print 'Nothing is selected'
    else:
        if modifiers == 0:
            first_selected = cmds.ls( sl=True )[0]
            o_time = int(cmds.currentTime( query=True ))
            cmds.selectKey(first_selected,replace=True,time=(o_time,o_time),attribute='rotateY')
        elif modifiers == 1:
            grp_panel_no_b = str( cmds.getPanel( withFocus=True )[11:] )
            outline_ed_name = "graphEditor" + grp_panel_no_b + 'OutlineEd'
            mel.eval('string $outlineed_name = "%s"' % outline_ed_name)
            c_ry = cmds.button('b_c_ry'+ grp_panel_no_b,q=1,bgc=True)
            if(c_ry==[0.0,0.30000762951094834,0.0]):
                cmds.button('b_c_ry'+ grp_panel_no_b,edit=1,bgc=[0.0,1.0,0.0])
                mel.eval('filterUISelectAttributesCheckbox rotateY 1 $outlineed_name;')
            elif(c_ry==[0.0,1.0,0.0]):
                cmds.button('b_c_ry'+ grp_panel_no_b,edit=1,bgc=[0.0,0.3,0.0])
                mel.eval('filterUISelectAttributesCheckbox rotateY 0 $outlineed_name;')

def filter_ry2(*args):
    pass

def select_curve_rz(*args):
    if not cmds.ls( sl=True ):
        print 'Nothing is selected'
    else:
        first_selected = cmds.ls( sl=True )[0]
        cmds.selectKey(first_selected,replace=True,attribute='rotateZ')

def filter_rz( dragControl, x, y, modifiers ):
    if not cmds.ls( sl=True ):
        print 'Nothing is selected'
    else:
        if modifiers == 0:
            first_selected = cmds.ls( sl=True )[0]
            o_time = int(cmds.currentTime( query=True ))
            cmds.selectKey(first_selected,replace=True,time=(o_time,o_time),attribute='rotateZ')
        elif modifiers == 1:
            grp_panel_no_b = str( cmds.getPanel( withFocus=True )[11:] )
            outline_ed_name = "graphEditor" + grp_panel_no_b + 'OutlineEd'
            mel.eval('string $outlineed_name = "%s"' % outline_ed_name)
            c_rz = cmds.button('b_c_rz'+ grp_panel_no_b,q=1,bgc=True)
            if(c_rz==[0.0,0.0,0.30000762951094834]):
                cmds.button('b_c_rz'+ grp_panel_no_b,edit=1,bgc=[0.0,0.0,1.0])
                mel.eval('filterUISelectAttributesCheckbox rotateZ 1 $outlineed_name;')
            elif(c_rz==[0.0,0.0,1.0]):
                cmds.button('b_c_rz'+ grp_panel_no_b,edit=1,bgc=[0.0,0.0,0.3])
                mel.eval('filterUISelectAttributesCheckbox rotateZ 0 $outlineed_name;')

def filter_rz2(*args):
    pass

def select_curve_sx(*args):
    if not cmds.ls( sl=True ):
        print 'Nothing is selected'
    else:
        first_selected = cmds.ls( sl=True )[0]
        cmds.selectKey(first_selected,replace=True,attribute='scaleX')

def filter_sx( dragControl, x, y, modifiers ):
    if not cmds.ls( sl=True ):
        print 'Nothing is selected'
    else:
        if modifiers == 0:
            first_selected = cmds.ls( sl=True )[0]
            o_time = int(cmds.currentTime( query=True ))
            cmds.selectKey(first_selected,replace=True,time=(o_time,o_time),attribute='scaleX')
        elif modifiers == 1:
            grp_panel_no_b = str( cmds.getPanel( withFocus=True )[11:] )
            outline_ed_name = "graphEditor" + grp_panel_no_b + 'OutlineEd'
            mel.eval('string $outlineed_name = "%s"' % outline_ed_name)
            c_sx = cmds.button('b_c_sx'+ grp_panel_no_b,q=1,bgc=True)
            if(c_sx==[0.30000762951094834, 0.0, 0.0]):
                cmds.button('b_c_sx'+ grp_panel_no_b,edit=1,bgc=[1.0,0.0,0.0])
                mel.eval('filterUISelectAttributesCheckbox scaleX 1 $outlineed_name;')
            elif(c_sx==[1.0,0.0,0.0]):
                cmds.button('b_c_sx'+ grp_panel_no_b,edit=1,bgc=[0.3,0.0,0.0])
                mel.eval('filterUISelectAttributesCheckbox scaleX 0 $outlineed_name;')

def filter_sx2(*args):
    pass

def select_curve_sy(*args):
    if not cmds.ls( sl=True ):
        print 'Nothing is selected'
    else:
        first_selected = cmds.ls( sl=True )[0]
        cmds.selectKey(first_selected,replace=True,attribute='scaleY')

def filter_sy( dragControl, x, y, modifiers ):
    if not cmds.ls( sl=True ):
        print 'Nothing is selected'
    else:
        if modifiers == 0:
            first_selected = cmds.ls( sl=True )[0]
            o_time = int(cmds.currentTime( query=True ))
            cmds.selectKey(first_selected,replace=True,time=(o_time,o_time),attribute='scaleY')
        elif modifiers == 1:
            grp_panel_no_b = str( cmds.getPanel( withFocus=True )[11:] )
            outline_ed_name = "graphEditor" + grp_panel_no_b + 'OutlineEd'
            mel.eval('string $outlineed_name = "%s"' % outline_ed_name)
            c_sy = cmds.button('b_c_sy'+ grp_panel_no_b,q=1,bgc=True)
            if(c_sy==[0.0,0.30000762951094834,0.0]):
                cmds.button('b_c_sy'+ grp_panel_no_b,edit=1,bgc=[0.0,1.0,0.0])
                mel.eval('filterUISelectAttributesCheckbox scaleY 1 $outlineed_name;')
            elif(c_sy==[0.0,1.0,0.0]):
                cmds.button('b_c_sy'+ grp_panel_no_b,edit=1,bgc=[0.0,0.3,0.0])
                mel.eval('filterUISelectAttributesCheckbox scaleY 0 $outlineed_name;')

def filter_sy2(*args):
    pass

def select_curve_sz(*args):
    if not cmds.ls( sl=True ):
        print 'Nothing is selected'
    else:
        first_selected = cmds.ls( sl=True )[0]
        cmds.selectKey(first_selected,replace=True,attribute='scaleZ')

def filter_sz( dragControl, x, y, modifiers ):
    if not cmds.ls( sl=True ):
        print 'Nothing is selected'
    else:
        if modifiers == 0:
            first_selected = cmds.ls( sl=True )[0]
            o_time = int(cmds.currentTime( query=True ))
            cmds.selectKey(first_selected,replace=True,time=(o_time,o_time),attribute='scaleZ')
        elif modifiers == 1:
            grp_panel_no_b = str( cmds.getPanel( withFocus=True )[11:] )
            outline_ed_name = "graphEditor" + grp_panel_no_b + 'OutlineEd'
            mel.eval('string $outlineed_name = "%s"' % outline_ed_name)
            c_sz = cmds.button('b_c_sz'+ grp_panel_no_b,q=1,bgc=True)
            if(c_sz==[0.0,0.0,0.30000762951094834]):
                cmds.button('b_c_sz'+ grp_panel_no_b,edit=1,bgc=[0.0,0.0,1.0])
                mel.eval('filterUISelectAttributesCheckbox scaleZ 1 $outlineed_name;')
            elif(c_sz==[0.0,0.0,1.0]):
                cmds.button('b_c_sz'+ grp_panel_no_b,edit=1,bgc=[0.0,0.0,0.3])
                mel.eval('filterUISelectAttributesCheckbox scaleZ 0 $outlineed_name;')

def filter_sz2(*args):
    pass

def select_curve_v(*args):
    if not cmds.ls( sl=True ):
        print 'Nothing is selected'
    else:
        first_selected = cmds.ls( sl=True )[0]
        cmds.selectKey(first_selected,replace=True,attribute='visibility')

def filter_v( dragControl, x, y, modifiers ):
    if not cmds.ls( sl=True ):
        print 'Nothing is selected'
    else:
        if modifiers == 0:
            first_selected = cmds.ls( sl=True )[0]
            o_time = int(cmds.currentTime( query=True ))
            cmds.selectKey(first_selected,replace=True,time=(o_time,o_time),attribute='visibility')
        elif modifiers == 1:
            grp_panel_no_b = str( cmds.getPanel( withFocus=True )[11:] )
            outline_ed_name = "graphEditor" + grp_panel_no_b + 'OutlineEd'
            mel.eval('string $outlineed_name = "%s"' % outline_ed_name)
            c_v = cmds.button('b_c_v'+ grp_panel_no_b,q=1,bgc=True)
            if(c_v==[0.30000762951094834, 0.30000762951094834, 0.30000762951094834]):
                cmds.button('b_c_v'+ grp_panel_no_b,edit=1,bgc=[0.8,0.8,0.8])
                mel.eval('filterUISelectAttributesCheckbox visibility 1 $outlineed_name;')
            elif(c_v==[0.8,0.8,0.8]):
                cmds.button('b_c_v'+ grp_panel_no_b,edit=1,bgc=[0.3,0.3,0.3])
                mel.eval('filterUISelectAttributesCheckbox visibility 0 $outlineed_name;')

def filter_v2(*args):
    pass

def show_spreadsheet(*args):
    try:
        o_sel_curve = cmds.keyframe( query=True, selected=True, name=True)[0]
        if cmds.about(api=True) >= 201350:
            mel.eval('string $animCurves_r[];')
            mel.eval('$animCurves_r = `keyframe -query -name`;')
            mel.eval('showEditor $animCurves_r[0];')
            mel.eval('commitAENotes($gAECurrentTab);copyAEWindow;')
            mel.eval('commitAENotes($gAECurrentTab);ToggleAttributeEditor;')
            
            if cmds.nodeType(o_sel_curve) == 'animCurveTL':
                mel.eval('checkBoxGrp -edit -value1 1 expandChkBoxGrpanimCurveTL;')
                mel.eval('keyframeOutliner -edit -display "wide" keyOutlineranimCurveTL;')
            elif cmds.nodeType(o_sel_curve) == 'animCurveTA':
                mel.eval('checkBoxGrp -edit -value1 1 expandChkBoxGrpanimCurveTA;')
                mel.eval('keyframeOutliner -edit -display "wide" keyOutlineranimCurveTA;')
            elif cmds.nodeType(o_sel_curve) == 'animCurveTU':
                mel.eval('checkBoxGrp -edit -value1 1 expandChkBoxGrpanimCurveTU;')
                mel.eval('keyframeOutliner -edit -display "wide" keyOutlineranimCurveTU;')

        else:
            mel.eval('string $animCurves_r[];')
            mel.eval('$animCurves_r = `keyframe -query -name`;')
            mel.eval('showEditor $animCurves_r[0];')
            mel.eval('commitAENotes($gAECurrentTab);copyAEWindow;')
            mel.eval('commitAENotes($gAECurrentTab);ToggleAttributeEditor;')
            mel.eval('checkBoxGrp -edit -value1 1 expandChkBoxGrp;')
            mel.eval('keyframeOutliner -edit -display "wide" keyOutliner;')
    except:
        print 'Animation Key is Not Seleced'

def get_all_index_inout(*args):
    try:
        cmds.keyframe( query=True, selected=True, name=True)[0]

        grp_panel_no_b = str( cmds.getPanel( withFocus=True )[11:] )

        cmds.keyTangent( lock=False )

        selected_f_curve_in_angle = cmds.keyTangent(q=True, inAngle=True)[0]
        selected_f_curve_in_weight = cmds.keyTangent(q=True, inWeight=True)[0]
        selected_f_curve_out_angle = cmds.keyTangent(q=True, outAngle=True)[0]
        selected_f_curve_out_weight = cmds.keyTangent(q=True, outWeight=True)[0]

        cmds.keyTangent( lock=True )

        cmds.floatFieldGrp('Index_InAngle'+ grp_panel_no_b, edit=True, value1=selected_f_curve_in_angle)
        cmds.floatFieldGrp('Index_InWeight'+ grp_panel_no_b, edit=True, value1=selected_f_curve_in_weight)
        cmds.floatFieldGrp('Index_OutAngle'+ grp_panel_no_b, edit=True, value1=selected_f_curve_out_angle)
        cmds.floatFieldGrp('Index_OutWeight'+ grp_panel_no_b, edit=True, value1=selected_f_curve_out_weight)

    except:
        print 'Animation Key is Not Seleced'

def set_in_angle(*args):
    try:
        cmds.keyframe( query=True, selected=True, name=True)[0]

        grp_panel_no_b = str( cmds.getPanel( withFocus=True )[11:] )
        set_angle = cmds.floatFieldGrp('Index_InAngle'+ grp_panel_no_b, q=True, value1=True)
        cmds.keyTangent( lock=False )
        cmds.keyTangent(edit=True,absolute=True, inAngle=set_angle)

    except:
        print 'Animation Key is Not Seleced'

def set_out_angle(*args):
    try:
        cmds.keyframe( query=True, selected=True, name=True)[0]

        grp_panel_no_b = str( cmds.getPanel( withFocus=True )[11:] )
        set_angle = cmds.floatFieldGrp('Index_OutAngle'+ grp_panel_no_b, q=True, value1=True)
        cmds.keyTangent( lock=False )
        cmds.keyTangent(edit=True,absolute=True, outAngle=set_angle)

    except:
        print 'Animation Key is Not Seleced'

def set_in_weight(*args):
    try:
        cmds.keyframe( query=True, selected=True, name=True)[0]

        grp_panel_no_b = str( cmds.getPanel( withFocus=True )[11:] )
        set_weight = cmds.floatFieldGrp('Index_InWeight'+ grp_panel_no_b, q=True, value1=True)
        cmds.keyTangent( lock=False )
        cmds.keyTangent(edit=True,absolute=True, inWeight=set_weight)

    except:
        print 'Animation Key is Not Seleced'


def set_out_weight(*args):
    try:
        cmds.keyframe( query=True, selected=True, name=True)[0]

        grp_panel_no_b = str( cmds.getPanel( withFocus=True )[11:] )
        set_weight = cmds.floatFieldGrp('Index_OutWeight'+ grp_panel_no_b, q=True, value1=True)
        cmds.keyTangent( lock=False )
        cmds.keyTangent(edit=True,absolute=True, outWeight=set_weight)

    except:
        print 'Animation Key is Not Seleced'


def o_prev_cmd(*args):
    n_prevCmd = int(cmds.findKeyframe(timeSlider=True, which='previous' ))
    cmds.currentTime(n_prevCmd, edit=True )

def o_key_prev_cmd( dragControl, x, y, modifiers ):
    if modifiers == 0:
        try:
            selected_f_curve = cmds.keyframe( query=True, selected=True, name=True)[0]
            selected_f_curve_obj = (selected_f_curve[:selected_f_curve.index('_')])
            selected_f_curve_att = (selected_f_curve[selected_f_curve.index('_')+1:])
            selected_f_curve_key = cmds.keyframe( query=True, selected=True)[0]

            cmds.selectKey(selected_f_curve)
            selected_f_curve_keys = cmds.keyframe( query=True, selected=True)

            o_index = 0
            for o_frame in selected_f_curve_keys:
                if selected_f_curve_key <= o_frame:
                    break
                o_index = o_index + 1

            b_frame = selected_f_curve_keys[o_index - 1]

#            cmds.selectKey(selected_f_curve_obj, time=(b_frame,b_frame), attribute=selected_f_curve_att )
            cmds.selectKey(selected_f_curve, time=(b_frame,b_frame),r=True,keyframe=True) 

        except:
            print 'Animation Key is Not Seleced'

    elif modifiers == 1:
        try:
            selected_f_curve = cmds.keyframe( query=True, selected=True, name=True)[0]
            cmds.selectKey(selected_f_curve)
            selected_f_curve_obj = (selected_f_curve[:selected_f_curve.index('_')])
            selected_f_curve_att = (selected_f_curve[selected_f_curve.index('_')+1:])

            selected_f_curve_keys = cmds.keyframe( query=True, selected=True)

            o_current_time = int(cmds.currentTime( query=True ))

            o_index = 0
            for o_frame in selected_f_curve_keys:
                if o_current_time <= o_frame:
                    break
                o_index = o_index + 1

            b_frame = selected_f_curve_keys[o_index - 1]

#            cmds.selectKey(selected_f_curve_obj, time=(b_frame,b_frame), attribute=selected_f_curve_att )
            cmds.selectKey(selected_f_curve, time=(b_frame,b_frame),r=True,keyframe=True) 
        except:
            print 'Animation Key is Not Seleced'

def o_key_prev_cmd2(*args):
    pass

def o_next_cmd(*args):
    n_nextCmd = int(cmds.findKeyframe(timeSlider=True, which='next' ))
    cmds.currentTime(n_nextCmd, edit=True )

def o_key_next_cmd( dragControl, x, y, modifiers ):
    if modifiers == 0:
        try:
            selected_f_curve = cmds.keyframe( query=True, selected=True, name=True)[0]
            selected_f_curve_obj = (selected_f_curve[:selected_f_curve.index('_')])
            selected_f_curve_att = (selected_f_curve[selected_f_curve.index('_')+1:])
            selected_f_curve_key = cmds.keyframe( query=True, selected=True)[0]

            cmds.selectKey(selected_f_curve)
            selected_f_curve_keys = cmds.keyframe( query=True, selected=True)

            for o_frame in selected_f_curve_keys:
                if selected_f_curve_key < o_frame:
                    break
#            cmds.selectKey(selected_f_curve_obj, time=(o_frame,o_frame), attribute=selected_f_curve_att )
            cmds.selectKey(selected_f_curve, time=(o_frame,o_frame),r=True,keyframe=True) 

        except:
            print 'Animation Key is Not Seleced'

    elif modifiers == 1:
        try:
            selected_f_curve = cmds.keyframe( query=True, selected=True, name=True)[0]
            cmds.selectKey(selected_f_curve)
            selected_f_curve_obj = (selected_f_curve[:selected_f_curve.index('_')])
            selected_f_curve_att = (selected_f_curve[selected_f_curve.index('_')+1:])

            selected_f_curve_keys = cmds.keyframe( query=True, selected=True)

            o_current_time = int(cmds.currentTime( query=True ))

            for o_frame in selected_f_curve_keys:
                if o_current_time < o_frame:
                    break

#            cmds.selectKey(selected_f_curve_obj, time=(o_frame,o_frame), attribute=selected_f_curve_att )
            cmds.selectKey(selected_f_curve, time=(o_frame,o_frame),r=True,keyframe=True) 

        except:
            print 'Animation Key is Not Seleced'

def o_key_next_cmd2(*args):
    pass

def mirror_x(*args):
        try:
            selected_curve_key = cmds.keyframe( query=True, selected=True)

            n_start = selected_curve_key[0]
            k_count = -1
            for o_key in selected_curve_key:
                k_count = k_count + 1
            n_end = selected_curve_key[k_count]

            cmds.scaleKey(scaleSpecifiedKeys=True,newStartTime=n_end,newStartFloat=n_end,newEndTime=n_start,newEndFloat=n_start )
            mel.eval('doBuffer snapshot')
            mel.eval('doBuffer swap')

        except:
            print 'Animation Key is Not Seleced'

def mirror_y( dragControl, x, y, modifiers ):
    if modifiers == 0:
        try:
            mel.eval('doBuffer snapshot')
            mel.eval('doBuffer swap')
            cmds.scaleKey(scaleSpecifiedKeys=True,timeScale=1,timePivot=0,floatScale=1,floatPivot=0,valueScale=-1,valuePivot=0)
        except:
            print 'Animation Key is Not Seleced'

def mirror_y2(*args):
    pass

def custom_graph_editor(*args):

    grp_panel_no_a = str( len(cmds.getPanel( scriptType='graphEditor' )) + 1 )

    current_minimum_frame = cmds.playbackOptions(query=True, minTime=True)
    current_maxmum_frame = cmds.playbackOptions(query=True, maxTime=True)

    panel_name = "GraphEditor" + grp_panel_no_a
    mel.eval('string $panel_name = "%s"' % panel_name)
    mel.eval('tearOffPanel $panel_name "graphEditor" true;')

    outline_ed_name = "graphEditor" + grp_panel_no_a + 'OutlineEd'
    mel.eval('string $outlineed_name = "%s"' % outline_ed_name)

    graph_ed_name = "graphEditor" + grp_panel_no_a + 'GraphEd'
    mel.eval('string $o_graph_ed_name = "%s"' % graph_ed_name)
    mel.eval('animCurveEditor -edit -displayInfinities true $o_graph_ed_name;')

    mel.eval('filterUISelectAttributesCheckbox translateX 0 $outlineed_name;')
    mel.eval('filterUISelectAttributesCheckbox translateY 0 $outlineed_name;')
    mel.eval('filterUISelectAttributesCheckbox translateZ 0 $outlineed_name;')
    mel.eval('filterUISelectAttributesCheckbox rotateX 0 $outlineed_name;')
    mel.eval('filterUISelectAttributesCheckbox rotateY 0 $outlineed_name;')
    mel.eval('filterUISelectAttributesCheckbox rotateZ 0 $outlineed_name;')
    mel.eval('filterUISelectAttributesCheckbox scaleX 0 $outlineed_name;')
    mel.eval('filterUISelectAttributesCheckbox scaleY 0 $outlineed_name;')
    mel.eval('filterUISelectAttributesCheckbox scaleZ 0 $outlineed_name;')
    mel.eval('filterUISelectAttributesCheckbox visibility 0 $outlineed_name;')

    cmds.columnLayout( adjustableColumn=True )
    cmds.rowLayout(
        numberOfColumns=19,
        adjustableColumn=19
    )
    cmds.text('t')
    cmds.button('b_c_tx'+ grp_panel_no_a,label='X',bgc=[0.3,0.0,0.0],annotation='TranslateX',
        command=select_curve_tx,dragCallback=filter_tx,dropCallback=filter_tx2)
    cmds.button('b_c_ty'+ grp_panel_no_a,label='Y',bgc=[0.0,0.3,0.0],annotation='TranslateY',
        command=select_curve_ty,dragCallback=filter_ty,dropCallback=filter_ty2)
    cmds.button('b_c_tz'+ grp_panel_no_a,label='Z',bgc=[0.0,0.0,0.3],annotation='TranslateZ',
        command=select_curve_tz,dragCallback=filter_tz,dropCallback=filter_tz2)
    cmds.text('  r')
    cmds.button('b_c_rx'+ grp_panel_no_a,label='X',bgc=[0.3,0.0,0.0],annotation='RotateX',
        command=select_curve_rx,dragCallback=filter_rx,dropCallback=filter_rx2)
    cmds.button('b_c_ry'+ grp_panel_no_a,label='Y',bgc=[0.0,0.3,0.0],annotation='RotateY',
        command=select_curve_ry,dragCallback=filter_ry,dropCallback=filter_ry2)
    cmds.button('b_c_rz'+ grp_panel_no_a,label='Z',bgc=[0.0,0.0,0.3],annotation='RotateZ',
        command=select_curve_rz,dragCallback=filter_rz,dropCallback=filter_rz2)
    cmds.text('  s')
    cmds.button('b_c_sx'+ grp_panel_no_a,label='X',bgc=[0.3,0.0,0.0],annotation='ScaleX',
        command=select_curve_sx,dragCallback=filter_sx,dropCallback=filter_sx2)
    cmds.button('b_c_sy'+ grp_panel_no_a,label='Y',bgc=[0.0,0.3,0.0],annotation='ScaleY',
        command=select_curve_sy,dragCallback=filter_sy,dropCallback=filter_sy2)
    cmds.button('b_c_sz'+ grp_panel_no_a,label='Z',bgc=[0.0,0.0,0.3],annotation='ScaleZ',
        command=select_curve_sz,dragCallback=filter_sz,dropCallback=filter_sz2)
    cmds.text(' ')
    cmds.button('b_c_v'+ grp_panel_no_a,label='V',bgc=[0.3,0.3,0.3],annotation='Visibility',
        command=select_curve_v,dragCallback=filter_v,dropCallback=filter_v2)
    cmds.text('  ')

    cmds.symbolButton('time_prev'+ grp_panel_no_a,image='timeprev.xpm',
        command=o_prev_cmd,dragCallback=o_key_prev_cmd,dropCallback=o_key_prev_cmd2)
    cmds.symbolButton('time_next'+ grp_panel_no_a,image='timenext.xpm',
        command=o_next_cmd,dragCallback=o_key_next_cmd,dropCallback=o_key_next_cmd2)
    cmds.text('  ')

    cmds.timePort(enableBackground=True,bgc=[0.2,0.2,0.2],width=500,height=20 )


    cmds.setParent('..')
    cmds.rowLayout(
        numberOfColumns=20,
        adjustableColumn=13
    )
    cmds.text('anim')

    cmds.button('anim_save',label='Save',command=anim_save)

    cmds.button('anim_load',label='Load',command=anim_load)

    cmds.text('FBX')

    cmds.button('fbx_save',label='Save',command=fbx_save)

    cmds.button('fbx_load',label='Load',command=fbx_load)
    cmds.text('  ')
    cmds.button('select_hierarchy',label='SelectHierarchy',bgc=[0.2,0.2,0.2],command='cmds.select(hierarchy=True)')
    cmds.button('select_from_curve',label='SelectFromCurve',bgc=[0.25,0.25,0.25],command=select_objfrom_curve)
    cmds.text('  ')

    cmds.radioButtonGrp(
        'KeyInOutSelect',
        labelArray3=['Both', 'In', 'Out'],
        numberOfRadioButtons=3,
        select=1,
        columnWidth3=[50,40,50],
        onCommand1=lambda x:radio_button_grp_key(1),
        onCommand2=lambda x:radio_button_grp_key(2),
        onCommand3=lambda x:radio_button_grp_key(3)
    )

    cmds.floatSliderGrp(
        'KeyTangentAngle',
        label='Tangent Angle',
        value=0,
        field=True,
        minValue=-90,
        maxValue=90,
        sliderStep=1.0,
        columnWidth3=[80,40,80],
        changeCommand=lambda x:start_tan(x),
        dragCommand=lambda x:start_tan(x)
    )
    cmds.text('  ')

    cmds.symbolButton('time_rew'+ grp_panel_no_a,image='timerew.xpm',command="mel.eval('playButtonStart;')" )

    cmds.symbolButton('step_backward'+ grp_panel_no_a,image='timeend.xpm',command=step_backward)

    cmds.symbolButton('play_forward'+ grp_panel_no_a,image='timeplay.xpm',command=play_forward)

    cmds.symbolButton('step_forward'+ grp_panel_no_a,image='timestart.xpm',command=step_forward)

    cmds.symbolButton('time_fwd'+ grp_panel_no_a,image='timefwd.xpm',command="mel.eval('playButtonEnd;')" )

    cmds.text('Step')

    cmds.intField(
        'nStep'+ grp_panel_no_a,
        width=30,
        value=1
    )


    cmds.setParent('..')
    cmds.rowLayout(numberOfColumns=12)
    cmds.button('show_spreadsheet'+ grp_panel_no_a,label='Spreadsheet',bgc=[0.2,0.2,0.2],command=show_spreadsheet)
    cmds.button('mirror'+ grp_panel_no_a,label='Mirror',
        command=mirror_x,dragCallback=mirror_y,dropCallback=mirror_y2)
    cmds.text(' IndexInfo')
    cmds.button('Get_All_Index_InOut'+ grp_panel_no_a,label='GetAll',bgc=[0.4,0.4,0.4],command=get_all_index_inout)
    cmds.floatFieldGrp('Index_InAngle'+ grp_panel_no_a,numberOfFields=1, label='InAngle',precision=6,value1=0,columnWidth2=[55,70])
    cmds.button('Set_InAngle'+ grp_panel_no_a,label='Set',bgc=[0.35,0.35,0.35],command=set_in_angle)

    cmds.floatFieldGrp('Index_InWeight'+ grp_panel_no_a,numberOfFields=1, label='InWeight',precision=6,value1=0,columnWidth2=[65,70])
    cmds.button('Set_InWeight'+ grp_panel_no_a,label='Set',bgc=[0.35,0.35,0.35],command=set_in_weight)

    cmds.floatFieldGrp('Index_OutAngle'+ grp_panel_no_a,numberOfFields=1, label='OutAngle',precision=6,value1=0,columnWidth2=[70,70])
    cmds.button('Set_OutAngle'+ grp_panel_no_a,label='Set',bgc=[0.35,0.35,0.35],command=set_out_angle)

    cmds.floatFieldGrp('Index_OutWeight'+ grp_panel_no_a,numberOfFields=1, label='OutWeight',precision=6,value1=0,columnWidth2=[75,70])
    cmds.button('Set_OutWeight'+ grp_panel_no_a,label='Set',bgc=[0.35,0.35,0.35],command=set_out_weight)

